--
-- This file contains the various derivations of the FOR XML clause in
-- SQL Server 2000 to generate an XML stream based upon a SQL query
--

select EmployeeID, LastName, FirstName, City 
from Employees FOR XML RAW
go

select EmployeeID, LastName, FirstName, City from Employees
FOR XML AUTO
go

select 1 as Tag, NULL as Parent,
       NULL as [Root!1],
       NULL as [Employee!2!EmployeeID], 
       NULL as [Employee!2!FirstName!element],
       NULL as [Employee!2!LastName!element]
union all
select 2, 1, NULL, EmployeeID, FirstName, LastName 
from Employees
where EmployeeID < 4
FOR XML EXPLICIT
go


select EmployeeID, LastName, FirstName, City 
from Employees where EmployeeID < 4
FOR XML AUTO, XMLDATA
go

select EmployeeID, LastName, FirstName, City from Employees
where EmployeeID < 4
FOR XML AUTO, ELEMENTS
go

select FirstName, LastName, Photo from Employees
where EmployeeID = 1
FOR XML RAW, BINARY BASE64
go


declare @idoc int
declare @doc varchar(1000)
set @doc ='
<Root>
  <Employee EmployeeID="1">
    <FirstName>Nancy</FirstName>
    <LastName>Davolio</LastName>
  </Employee>
  <Employee EmployeeID="2">
    <FirstName>Andrew</FirstName>
    <LastName>Fuller</LastName>
  </Employee>
  <Employee EmployeeID="3">
    <FirstName>Janet</FirstName>
    <LastName>Leverling</LastName>
  </Employee>
</Root>'

exec sp_xml_preparedocument @idoc OUTPUT, @doc


SELECT *
FROM OPENXML (@idoc, '/Root/Employee',2)
     WITH (EmployeeID  varchar(10) '@EmployeeID',
           First_Name  varchar(20) 'FirstName',
           Last_Name   varchar(20) 'LastName' )

EXEC sp_xml_removedocument @idoc



CREATE PROCEDURE INSERT_XML_DATA
       @XMLDoc varchar(4000)
AS
  declare @ReturnCode int,
          @iDoc       int

  exec sp_xml_preparedocument @iDoc OUTPUT, @XMLDoc

  INSERT Employees(EmployeeID, FirstName, LastName)
  SELECT *
  FROM OPENXML (@idoc, '/Root/Employee',2)
       WITH (EmployeeID  varchar(10) '@EmployeeID',
             FirstName  varchar(20) 'FirstName',
             LastName   varchar(20) 'LastName' )

  exec sp_xml_removedocument @iDoc
 
  select @ReturnCode = 1

  return @ReturnCode

go
